# -*- coding: utf-8 -*-
# Spec_Recoeder Ver.1.0
# License = MIT
# Author = Yuta Minakawa
import subprocess
import datetime
import time
import os
import ConfigParser

import Image
import ImageDraw
import ImageFont

high_color = 0
mono_color = 0
del_mp3 = 0
write_filename = 0
write_csv = 0
conf = ConfigParser.SafeConfigParser()
conf.read("./sr.conf")
if conf.get("sox","high_color") == "on":
	high_color = 1
	print "high_color is available"
else:
	print "high_color is unavailable"
	
if conf.get("sox","mono_color") == "on":
	mono_color = 1
	print "mono_color is available"
else:
	print "mono_color is unavailable"
	
if conf.get("server", "server") == "on":
	subprocess.Popen(["python", "server.py"])
	print "HTTP server is working"
else:
	print "HTTP server is unavailable"
	
if conf.get("file", "del_mp3") == "on":
	del_mp3 = 1
	print "del_mp3 is available"
else:
	print "del_mp3 is unavailable"
	
if conf.get("file", "write_filename") == "on":
	write_filename = 1
	print "filename will be written"
else:
	print "filename will not be written"

if conf.get("file", "write_csv") == "on":
	write_csv = 1
	print "CSV file will be saved"
	
if os.name == 'posix':
	print "OS = Linux,etc This system is supported"
if os.name == 'nt':
	print "OS = Windows This system is NOT supported"
	
def freq_exec(rev):
	if rev == 1: 
		subprocess.Popen(['rec', '-c', '1', "test.wav", 'trim', '0', '00:10'])
		time.sleep(9)
		wait_time = 0
		while os.path.exists("test.wav") == 1:
			time.sleep(0.01)
			wait_time = wait_time + 1
			print 3
		if wait_time >= 100:
			subprocess.Popen(["python", "./freq_exec.py", str(wait_time)])
		else:
			subprocess.Popen(["python", "./freq_exec.py", "0"])
			print 12
	print "check:done"
	return(wait_time)

def write_cara(x,y,string,filename):
	font = ImageFont.truetype("/usr/share/fonts/truetype/takao-gothic/TakaoGothic.ttf", 15, encoding="utf-8")
	img = Image.open(filename)
	draw = ImageDraw.Draw(img)
	draw.text((x,y), string, font=font, fill=255)
	img.save(filename)

def rec(filename):
	#It is not used.
	output = subprocess.call()
	return(output)
	
def how_long(filename):
	output = subprocess.check_output(["soxi", "-d", filename])
	print output
	minute = output[4]
	ten_second = output[6]
	second = output[7]
	file_info = (minute , ten_second, second)
	return(file_info)
	
def write2freq_exec(content):
	f = open('text.txt', 'w')
	f.write(content)
	f.close()
	
def spec(filename):
	#output = subprocess.call(['sox', filename + ".mp3", "-n", 'rate', '3k',"spectrogram" , "-X", "8", "-Y", "300", "-o", filename + ".png" ])
	if high_color == 1:
		if mono_color == 1:
			output = subprocess.call(['sox', filename + ".mp3", "-n", 'rate', '3k',"spectrogram" , "-X", "8", "-Y", "300", "-z", "100", "-q", "30", "-h", "-m", "-o", filename + ".png" ])
		else:
			output = subprocess.call(['sox', filename + ".mp3", "-n", 'rate', '3k',"spectrogram" , "-X", "8", "-Y", "300", "-z", "100", "-q", "30", "-h", "-o", filename + ".png" ])
	else:
		if mono_color == 1:
			output = subprocess.call(['sox', filename + ".mp3", "-n", 'rate', '3k',"spectrogram" , "-X", "8", "-Y", "300", "-z", "100", "-q", "30", "-m", "-o", filename + ".png" ])
		else:
			output = subprocess.call(['sox', filename + ".mp3", "-n", 'rate', '3k',"spectrogram" , "-X", "8", "-Y", "300", "-z", "100", "-q", "30", "-o", filename + ".png" ])
	print filename +".png" + " was made"
	if high_color == 1:
		if mono_color == 1:
			subprocess.call(['sox', filename + ".mp3", "-n", 'rate', '3k',"spectrogram" , "-X", "8", "-Y", "300", "-z", "100", "-q", "30", "-h", "-m"])
		else:
			subprocess.call(['sox', filename + ".mp3", "-n", 'rate', '3k',"spectrogram" , "-X", "8", "-Y", "300", "-z", "100", "-q", "30", "-h"])
	else:
		if mono_color == 1:
			subprocess.call(['sox', filename + ".mp3", "-n", 'rate', '3k',"spectrogram" , "-X", "8", "-Y", "300", "-z", "100", "-q", "30", "-m"])
		else:
			subprocess.call(['sox', filename + ".mp3", "-n", 'rate', '3k',"spectrogram" , "-X", "8", "-Y", "300", "-z", "100", "-q", "30"])
	return(output)

print "Spec_Recorder Ver.b"

now_minute = int(datetime.datetime.now().strftime("%M"))
now_hour = int(datetime.datetime.now().strftime("%H"))
now_month = int(datetime.datetime.now().strftime("%m"))
now_day = int(datetime.datetime.now().strftime("%d"))
now_year = int(datetime.datetime.now().strftime("%Y"))

subprocess.Popen(["python", "./freq_exec.py", "0"])
print "Executed freq_exec.py"

while 1==1:
	if int(datetime.datetime.now().strftime("%M")) % 5 == 0:
		start_year = str(datetime.datetime.now().strftime("%Y"))[2:]
		start_month = str(datetime.datetime.now().strftime("%m"))[:]
		if start_month < 10:
			start_month = "0" + str(datetime.datetime.now().strftime("%m"))[:]
		start_day = str(datetime.datetime.now().strftime("%d"))[:]
		if start_day < 10:
			start_day = "0" + str(datetime.datetime.now().strftime("%d"))[:]
		start_hour = str(datetime.datetime.now().strftime("%H"))[:]
		if start_hour < 10:
			start_hour = "0" + str(datetime.datetime.now().strftime("%H"))[:]
		start_minute = str(datetime.datetime.now().strftime("%M"))[:]
		if datetime.datetime.now().strftime("%M") < 10:
			start_minute = "0" + str(datetime.datetime.now().strftime("%M"))[:]
		filename = str(start_year)[:] + str(start_month)[:] + str(start_day)[:] + str(start_hour)[:] + str(start_minute)[:]
		print "Audio fileneme is " + filename + ".mp3"
		print "Waiting 5 minutes"
		time.sleep(300)
		for cnt in range(20):
			if os.path.exists(filename + ".mp3") == 1:
				if how_long(filename + ".mp3")[0] == "5":
					break
			#print "Waiting for " + filename +".mp3."
			time.sleep(0.1)
		if os.path.exists(filename + ".mp3") == 1:
			spec(filename)
			if del_mp3 == 1:
				subprocess.call(["rm", filename + ".mp3"])
		else:
			print "Error! " + filename + ".mp3 is not found"
		for cnt in range(20):
			if os.path.exists(filename + ".png") == 1:
				print filename + ".png is exist"
				break
			print "Waiting for " + filename +".png"
			time.sleep(0.1)
		if write_filename == 1:
			if os.path.exists(filename + ".png") == 1:
				write_string = filename[:]
				write_cara(90,320,write_string,filename + ".png")
				write_cara(90,320,write_string,"spectrogram" + ".png")
		else:
			print "Error! " + filename + ".png is not found"
		if write_csv == 1:
			print "make csv"
			subprocess.Popen(["python", "./make_csv.py", "-c", filename])
		#img = Image.open(filename + ".png")
		#im = ImageDraw.ImageDraw(img)
		#im.rectangle((100, 100, 300, 300))
		#img.show()
	time.sleep(0.001)
	
